/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour.furniture;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.assets.entities.furniture.model.DoorState;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.entities.model.physical.furniture.DoorStateComponent;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.misc.VectorUtils;

public class DoorBehaviour
implements BehaviourComponent {
    private LocationComponent locationComponent;
    private MessageDispatcher messageDispatcher;
    private Entity parentEntity;
    public static final float ANIMATION_TIME = 0.4f;
    private float currentStateElapsedTime = 0.0f;
    private boolean doorOpenRequested;

    @Override
    public void init(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.locationComponent = parentEntity.getLocationComponent();
        this.messageDispatcher = messageDispatcher;
        this.parentEntity = parentEntity;
    }

    @Override
    public DoorBehaviour clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        DoorBehaviour cloned = new DoorBehaviour();
        cloned.init(this.parentEntity, messageDispatcher, tiledMap);
        return cloned;
    }

    public void doorOpenRequested() {
        DoorStateComponent doorStateComponent = this.parentEntity.getOrCreateComponent(DoorStateComponent.class);
        DoorState currentState = doorStateComponent.getState();
        if (currentState.equals((Object)DoorState.CLOSED) || currentState.equals((Object)DoorState.CLOSING)) {
            this.doorOpenRequested = true;
        }
    }

    @Override
    public void update(float deltaTime, TiledMap areaMap) {
        this.currentStateElapsedTime += deltaTime;
        DoorStateComponent doorStateComponent = this.parentEntity.getOrCreateComponent(DoorStateComponent.class);
        PhysicalEntityComponent physicalEntityComponent = this.parentEntity.getPhysicalEntityComponent();
        float currentAnimationProgress = physicalEntityComponent.getAnimationProgress();
        MapTile doorTile = areaMap.getTile(this.parentEntity.getLocationComponent().getWorldPosition());
        boolean otherEntityInTile = doorTile.getEntities().size() > 1;
        DoorState currentState = doorStateComponent.getState();
        if (this.doorOpenRequested) {
            this.switchState(DoorState.OPENING, doorStateComponent, this.messageDispatcher);
            this.doorOpenRequested = false;
        } else {
            switch (currentState) {
                case CLOSED: {
                    break;
                }
                case OPENING: {
                    currentAnimationProgress += deltaTime / 0.4f;
                    if (currentAnimationProgress >= 1.0f) {
                        currentAnimationProgress = 1.0f;
                        this.switchState(DoorState.OPEN, doorStateComponent, this.messageDispatcher);
                    }
                    physicalEntityComponent.setAnimationProgress(currentAnimationProgress);
                    break;
                }
                case OPEN: {
                    if (otherEntityInTile) {
                        this.currentStateElapsedTime = 0.0f;
                    }
                    if (!(this.currentStateElapsedTime > 1.0f)) break;
                    this.switchState(DoorState.CLOSING, doorStateComponent, this.messageDispatcher);
                    break;
                }
                case CLOSING: {
                    currentAnimationProgress -= deltaTime / 0.4f;
                    if (otherEntityInTile) {
                        this.switchState(DoorState.OPENING, doorStateComponent, this.messageDispatcher);
                    } else if (currentAnimationProgress <= 0.0f) {
                        currentAnimationProgress = 0.0f;
                        this.switchState(DoorState.CLOSED, doorStateComponent, this.messageDispatcher);
                    }
                    physicalEntityComponent.setAnimationProgress(currentAnimationProgress);
                }
            }
        }
    }

    private void switchState(DoorState newState, DoorStateComponent doorStateComponent, MessageDispatcher messageDispatcher) {
        DoorState previousState = doorStateComponent.getState();
        if (!previousState.equals((Object)newState)) {
            this.currentStateElapsedTime = 0.0f;
        }
        doorStateComponent.setState(newState);
        if (previousState.equals((Object)DoorState.CLOSED) || newState.equals((Object)DoorState.CLOSED)) {
            messageDispatcher.dispatchMessage(804, VectorUtils.toGridPoint(this.parentEntity.getLocationComponent().getWorldPosition()));
        }
    }

    @Override
    public void infrequentUpdate(GameContext gameContext) {
    }

    @Override
    public SteeringComponent getSteeringComponent() {
        return null;
    }

    @Override
    public boolean isUpdateEveryFrame() {
        return true;
    }

    @Override
    public boolean isUpdateInfrequently() {
        return false;
    }

    @Override
    public boolean isJobAssignable() {
        return false;
    }
}

